/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Point;
import org.jhotdraw.figures.PolyLineFigure;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.Locator;
import org.jhotdraw.standard.LocatorHandle;
import org.jhotdraw.standard.SingleFigureEnumerator;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class PolyLineHandle
extends LocatorHandle {
    private int fIndex;

    public PolyLineHandle(PolyLineFigure polyLineFigure, Locator locator, int n) {
        super(polyLineFigure, locator);
        this.fIndex = n;
    }

    public void invokeStart(int n, int n2, DrawingView drawingView) {
        this.setUndoActivity(this.createUndoActivity(drawingView, this.fIndex));
        this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.owner()));
        ((UndoActivity)this.getUndoActivity()).setOldPoint(new Point(n, n2));
    }

    public void invokeStep(int n, int n2, int n3, int n4, DrawingView drawingView) {
        int n5 = ((UndoActivity)this.getUndoActivity()).getPointIndex();
        this.myOwner().setPointAt(new Point(n, n2), n5);
    }

    public void invokeEnd(int n, int n2, int n3, int n4, DrawingView drawingView) {
        if (n == n3 && n2 == n4) {
            this.setUndoActivity(null);
        }
    }

    private PolyLineFigure myOwner() {
        return (PolyLineFigure)this.owner();
    }

    protected Undoable createUndoActivity(DrawingView drawingView, int n) {
        return new UndoActivity(drawingView, n);
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private Point myOldPoint;
        private int myPointIndex;

        public UndoActivity(DrawingView drawingView, int n) {
            super(drawingView);
            this.setUndoable(true);
            this.setRedoable(true);
            this.setPointIndex(n);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            return this.movePointToOldLocation();
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            return this.movePointToOldLocation();
        }

        protected boolean movePointToOldLocation() {
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            if (!figureEnumeration.hasNextFigure()) {
                return false;
            }
            PolyLineFigure polyLineFigure = (PolyLineFigure)figureEnumeration.nextFigure();
            Point point = polyLineFigure.pointAt(this.getPointIndex());
            polyLineFigure.setPointAt(this.getOldPoint(), this.getPointIndex());
            this.setOldPoint(point);
            return true;
        }

        public void setOldPoint(Point point) {
            this.myOldPoint = point;
        }

        public Point getOldPoint() {
            return this.myOldPoint;
        }

        public void setPointIndex(int n) {
            this.myPointIndex = n;
        }

        public int getPointIndex() {
            return this.myPointIndex;
        }
    }
}

